#ifndef _KERNEL_H_
#define _KERNEL_H_

#include <stdarg.h>
#include <toykernel/linkage.h>
#include <toykernel/stddef.h>
#include <toykernel/types.h>

#define INT_MAX		((int)(~0U>>1))
#define INT_MIN		(-INT_MAX - 1)
#define UINT_MAX	(~0U)
#define LONG_MAX	((long)(~0UL>>1))
#define LONG_MIN	(-LONG_MAX - 1)
#define ULONG_MAX	(~0UL)

# define NORET_TYPE    /**/
# define ATTRIB_NORET  __attribute__((noreturn))
# define NORET_AND     noreturn,

#ifdef __i386__
#define FASTCALL(x)	x __attribute__((regparm(3)))
#else
#define FASECALL(x)	x
#endif

NORET_TYPE void panic(const char *fmt, ...);
NORET_TYPE void do_exit(long error_code) ATTRIB_NORET;

extern void test_cls(void);

extern int printk(const char *fmt, ...);
extern int vsprintf(char *buf, const char *, va_list);

#endif

