#include "stdafx.h"
#include <commctrl.h>
#include <process.h>
#include <xtrace.h>

#include "traypos.h"
#include "resource.h"

CTrayPos::CTrayPos()
{
	UINT	uThreadId;

	m_bTrackMouse = FALSE;
	m_hExitEvent = CreateEvent(NULL, FALSE, FALSE, NULL);
	m_hThread = (HANDLE) _beginthreadex(NULL, 0, CTrayPos::TrackMousePt, this, 0, &uThreadId);
	InitializeCriticalSection(&m_cs);
}

CTrayPos::~CTrayPos()
{
	if(m_hThread != NULL)
	{
		SetEvent(m_hExitEvent);
		if(WaitForSingleObject(m_hThread, 5000) == WAIT_TIMEOUT)
		{
			TerminateThread(m_hThread, 0);
		}

		CloseHandle(m_hThread);
		m_hThread = NULL;
	}

	if(m_hExitEvent != NULL)
	{
		CloseHandle(m_hExitEvent);
		m_hExitEvent = NULL;
	}

	DeleteCriticalSection(&m_cs);
}

/*
//Old TrackMousePt
UINT CALLBACK CTrayPos::TrackMousePt(PVOID pvClass)
{
	POINT		ptMouse;
	CTrayPos	*pTrayPos = (CTrayPos *) pvClass;

	while(WaitForSingleObject(pTrayPos->m_hExitEvent, 200) == WAIT_TIMEOUT)
	{

		if(pTrayPos->m_bTrackMouse == TRUE)
		{
			GetCursorPos(&ptMouse);
			XTRACE("PTINRECT [%d,%d] - [%d,%d,%d,%d]", ptMouse.x, ptMouse.y, pTrayPos->m_rcTray.left, pTrayPos->m_rcTray.top, pTrayPos->m_rcTray.right, pTrayPos->m_rcTray.bottom);
			if(PtInRect(&pTrayPos->m_rcTray, ptMouse) == FALSE)
			{
				pTrayPos->m_bTrackMouse = FALSE;
				pTrayPos->OnMouseLeave();
			}
		}
	}

	return 0;
}
*/

UINT CALLBACK CTrayPos::TrackMousePt(PVOID pvClass)
{
	POINT		ptMouse;
	CTrayPos	*pTrayPos = (CTrayPos *) pvClass;

	while(WaitForSingleObject(pTrayPos->m_hExitEvent, 2000) == WAIT_TIMEOUT)
	{

		if(pTrayPos->m_bTrackMouse == TRUE)
		{
			GetCursorPos(&ptMouse);
			
			if(ptMouse.x != pTrayPos->m_ptMouse.x || ptMouse.y != pTrayPos->m_ptMouse.y)
			{
				pTrayPos->m_bTrackMouse = FALSE;
				pTrayPos->OnMouseLeave();
			}
		}
	}

	return 0;
}

HWND CTrayPos::FindTrayToolWnd()
{
	HWND	hShellTrayWnd = NULL;
	HWND	hTrayNotify = NULL;
	HWND	hTool = NULL;
	HWND	hPager = NULL;

	hShellTrayWnd = FindWindow("Shell_TrayWnd", NULL);

	if(hShellTrayWnd != NULL)
	{
		hTrayNotify = FindWindowEx(hShellTrayWnd, NULL, "TrayNotifyWnd", NULL);

		if(hTrayNotify != NULL)
		{
			hPager = FindWindowEx(hTrayNotify, NULL, "SysPager", NULL);

			if(hPager != NULL)
				hTool = FindWindowEx(hPager, NULL, "ToolbarWindow32", NULL);
			else
				hTool = FindWindowEx(hTrayNotify, NULL, "ToolbarWindow32", NULL);		

			if(hTool == NULL)
				hTool = hTrayNotify;
		}
	}

	return hTool;
}

/*
// Old OnMouseMove
VOID CTrayPos::OnMouseMove()
{
	HWND	hTool = NULL;
	TCHAR	szClass[MAX_PATH] = {0};

	EnterCriticalSection(&m_cs);

	hTool = FindTrayToolWnd();

	RECT	rcToolBar;
	RECT	rcTmp;
	POINT	ptMouse;
	int		x, y;
	int		cx, cy;

	LONG	dwBtnSize;

    GetCursorPos(&ptMouse);

	if(hTool != NULL)
	{
		GetWindowRect(hTool, &rcToolBar);

		dwBtnSize = (LONG) SendMessage(hTool, TB_GETBUTTONSIZE, 0, 0);

		cx = LOWORD(dwBtnSize);
		cy = HIWORD(dwBtnSize);
	}
	else
	{
		hTool = FindTrayNotifyWnd();

		GetWindowRect(hTool, &rcToolBar);
		cx = 17;
		cy = 17;

		rcToolBar.left += 2;
		rcToolBar.top += 2;
	}

	for(y=rcToolBar.top; y<rcToolBar.bottom; y+=cy)
	{
		for(x=rcToolBar.left; x<rcToolBar.right; x+=cx)
		{
			SetRect(&rcTmp, x+1, y+1, x+cx, y+cy);

			if(PtInRect(&rcTmp, ptMouse) == TRUE)
			{
				CopyRect(&m_rcTray, &rcTmp);

				if(m_bTrackMouse == FALSE)
					OnMouseEnter();

				m_bTrackMouse = TRUE;
				y = rcToolBar.bottom;

				break;
			}
		}
	}

	LeaveCriticalSection(&m_cs);
}
*/

VOID CTrayPos::OnMouseMove()
{
	EnterCriticalSection(&m_cs);

	GetCursorPos(&m_ptMouse);
	if(m_bTrackMouse == FALSE)
	{
		OnMouseEnter();
		m_bTrackMouse = TRUE;
	}

	LeaveCriticalSection(&m_cs);
}

BOOL CTrayPos::IsMouseOver()
{
	return m_bTrackMouse;
}

//////////////////////////////////////////////////////////////////////////

CMsgTrayPos::CMsgTrayPos(HWND hwnd, UINT uID, UINT uCallbackMsg)
	: CTrayPos()
{
	SetNotifyIconInfo(hwnd, uID, uCallbackMsg);
}

CMsgTrayPos::~CMsgTrayPos()
{
}

VOID CMsgTrayPos::SetNotifyIconInfo(HWND hwnd, UINT uID, UINT uCallbackMsg)
{
	m_hNotifyWnd = hwnd;
	m_uID = uID;
	m_uCallbackMsg = uCallbackMsg;
}

VOID CMsgTrayPos::OnMouseEnter()
{
	XTRACE("OnMouseEnter");

	if(m_hNotifyWnd != NULL && IsWindow(m_hNotifyWnd))
		PostMessage(m_hNotifyWnd, m_uCallbackMsg, m_uID, WM_MOUSEHOVER);
}

VOID CMsgTrayPos::OnMouseLeave()
{
	XTRACE("OnMouseLeave");

	if(m_hNotifyWnd != NULL && IsWindow(m_hNotifyWnd))
		PostMessage(m_hNotifyWnd, m_uCallbackMsg, m_uID, WM_MOUSELEAVE);
}