#include "stdafx.h"
#include "traypos.h"
#include <process.h>

#include "resource.h"

CTrayPos::CTrayPos()
{
	UINT	uThreadId;

	m_bTrackMouse = FALSE;
	m_hExitEvent = CreateEvent(NULL, FALSE, FALSE, NULL);
	m_hThread = (HANDLE) _beginthreadex(NULL, 0, CTrayPos::TrackMousePt, this, 0, &uThreadId);
	InitializeCriticalSection(&m_cs);
}

CTrayPos::~CTrayPos()
{
	if(m_hThread != NULL)
	{
		SetEvent(m_hExitEvent);
		if(WaitForSingleObject(m_hThread, 5000) == WAIT_TIMEOUT)
		{
			TerminateThread(m_hThread, 0);
		}

		CloseHandle(m_hThread);
		m_hThread = NULL;
	}

	if(m_hExitEvent != NULL)
	{
		CloseHandle(m_hExitEvent);
		m_hExitEvent = NULL;
	}

	DeleteCriticalSection(&m_cs);
}

UINT CALLBACK CTrayPos::TrackMousePt(PVOID pvClass)
{
	POINT		ptMouse;
	CTrayPos	*pTrayPos = (CTrayPos *) pvClass;

	while(WaitForSingleObject(pTrayPos->m_hExitEvent, 1000) == WAIT_TIMEOUT)
	{
		if(pTrayPos->m_bTrackMouse == TRUE)
		{
			GetCursorPos(&ptMouse);
			if(PtInRect(&pTrayPos->m_rcTray, ptMouse) == FALSE)
			{
				pTrayPos->m_bTrackMouse = FALSE;
				pTrayPos->OnMouseLeave();
			}
		}
	}

	return 0;
}

HWND CTrayPos::FindTrayToolWnd()
{
	HWND	hShellTrayWnd = NULL;
	HWND	hTrayNotify = NULL;
	HWND	hSysPager = NULL;
	HWND	hTool = NULL;

	hShellTrayWnd = FindWindow("Shell_TrayWnd", NULL);

	if(hShellTrayWnd != NULL)
	{
		hTrayNotify = FindWindowEx(hShellTrayWnd, NULL, "TrayNotifyWnd", NULL);

		if(hTrayNotify != NULL)
		{
			hSysPager = FindWindowEx(hTrayNotify, NULL, "SysPager", NULL);

			if(hSysPager != NULL)
				hTool = FindWindowEx(hSysPager, NULL, "ToolbarWindow32", NULL);
			else
				hTool = FindWindowEx(hTrayNotify, NULL, "ToolbarWindow32", NULL);
		}
	}

	return hTool;
}

VOID CTrayPos::OnMouseMove()
{
	HWND	hTool = NULL;

	EnterCriticalSection(&m_cs);

	if(m_bTrackMouse == TRUE)
		return;


	hTool = FindTrayToolWnd();
	if(hTool != NULL)
	{
		RECT	rcToolBar;
		RECT	rcTmp;
		POINT	ptMouse;
		int		x, y;
		int		cx, cy;

		LONG	dwBtnSize;

		dwBtnSize = (LONG) SendMessage(hTool, TB_GETBUTTONSIZE, 0, 0);

		cx = LOWORD(dwBtnSize);
		cy = HIWORD(dwBtnSize);


		GetCursorPos(&ptMouse);
		GetWindowRect(hTool, &rcToolBar);

		for(y=rcToolBar.top; y<rcToolBar.bottom; y+=cy)
			for(x=rcToolBar.left; x<rcToolBar.right; x+=cx)
			{
				SetRect(&rcTmp, x, y, x+cx, y+cy);
				if(PtInRect(&rcTmp, ptMouse) == TRUE)
				{
					CopyRect(&m_rcTray, &rcTmp);

					m_bTrackMouse = TRUE;
					y = rcToolBar.bottom;

					OnMouseEnter();
					break;
				}
			}
	}

	LeaveCriticalSection(&m_cs);
}

BOOL CTrayPos::IsMouseOver()
{
	return m_bTrackMouse;
}

//////////////////////////////////////////////////////////////////////////

CMsgTrayPos::CMsgTrayPos(HWND hwnd, UINT uID, UINT uCallbackMsg)
	: CTrayPos()
{
	SetNotifyIconInfo(hwnd, uID, uCallbackMsg);
}

CMsgTrayPos::~CMsgTrayPos()
{
}

VOID CMsgTrayPos::SetNotifyIconInfo(HWND hwnd, UINT uID, UINT uCallbackMsg)
{
	m_hNotifyWnd = hwnd;
	m_uID = uID;
	m_uCallbackMsg = uCallbackMsg;
}

VOID CMsgTrayPos::OnMouseEnter()
{
	OutputDebugString("OnMouseEnter");

	if(m_hNotifyWnd != NULL && IsWindow(m_hNotifyWnd))
		PostMessage(m_hNotifyWnd, m_uCallbackMsg, m_uID, WM_MOUSEHOVER);
}

VOID CMsgTrayPos::OnMouseLeave()
{
	OutputDebugString("OnMouseLeave");

	if(m_hNotifyWnd != NULL && IsWindow(m_hNotifyWnd))
		PostMessage(m_hNotifyWnd, m_uCallbackMsg, m_uID, WM_MOUSELEAVE);
}