// trayhk.cpp : DLL  α׷   մϴ.
//

#include "stdafx.h"
#include <xtrace.h>

#include "trayhk.h"

typedef struct _SHRDATA
{
    HHOOK	hHook;
	HWND	hNotifyWnd;
	UINT	uCallbackMsg;
	BOOL	bHookPause;
} SHRDATA, *PSHRDATA;

HINSTANCE	g_hInst;

#pragma data_seg("TRAYHK")
SHRDATA	g_ShrData = {NULL, NULL, 0};
#pragma data_seg()

#pragma comment(linker, "/SECTION:TRAYHK,rws")


BOOL APIENTRY DllMain( HANDLE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 )
{
	g_hInst = (HINSTANCE) hModule;
    return TRUE;
}

LRESULT CALLBACK TrayMsgProc(int nCode, WPARAM wParam, LPARAM lParam)
{
	if(nCode >= 0)
	{
		if(g_ShrData.bHookPause == FALSE)
		{
			PMSG	pmsg = (PMSG) lParam;

			if(pmsg->message == WM_MOUSEWHEEL)
			{
				PostMessage(g_ShrData.hNotifyWnd, g_ShrData.uCallbackMsg, pmsg->wParam, pmsg->lParam);
				XTRACE("Wheel %d", GET_WHEEL_DELTA_WPARAM(pmsg->wParam));
			}

			/*
			if(pmsg->message == WM_MOUSEMOVE)
			{
				XTRACE("MOve %d, %d", wParam, lParam);
			}
			*/
		}
	}

	return CallNextHookEx(g_ShrData.hHook, nCode, wParam, lParam);
}

LRESULT CALLBACK TrayMouseProc(int nCode, WPARAM wParam, LPARAM lParam)
{
	if(nCode >= 0)
	{
		if(g_ShrData.bHookPause == FALSE)
		{
			if(wParam == WM_MOUSEWHEEL)
			{
				PMOUSEHOOKSTRUCT	pms = (PMOUSEHOOKSTRUCT) lParam;

				PostMessage(g_ShrData.hNotifyWnd, g_ShrData.uCallbackMsg, pms->dwExtraInfo, 0);
				XTRACE("Wheel Extra = %x, %d hi = %x, low = %x", pms->dwExtraInfo, pms->dwExtraInfo, pms->dwExtraInfo, pms->dwExtraInfo);
			}
		}
	}

	return CallNextHookEx(g_ShrData.hHook, nCode, wParam, lParam);
}

LRESULT CALLBACK TrayMouseLLProc(int nCode, WPARAM wParam, LPARAM lParam)
{
	if(nCode >= 0)
	{
		if(g_ShrData.bHookPause == FALSE)
		{
			if(wParam == WM_MOUSEWHEEL)
			{
				PMSLLHOOKSTRUCT	pms = (PMSLLHOOKSTRUCT) lParam;
				PostMessage(g_ShrData.hNotifyWnd, g_ShrData.uCallbackMsg, pms->mouseData, 0);
				return 1;
			}
		}
	}

	return CallNextHookEx(g_ShrData.hHook, nCode, wParam, lParam);
}

TRAYHK_API
BOOL WINAPI InstallHook(HWND hNotifyWnd, UINT uCallbackMsg)
{
	BOOL	bRet = FALSE;

	if(g_ShrData.hHook == NULL)
	{
		if(LOWORD(GetVersion()) < 5)
		{
			HWND	hShellTrayWnd = NULL;
			HWND	hTrayNotify = NULL;
			HWND	hTool = NULL;

			hShellTrayWnd = FindWindow("Shell_TrayWnd", NULL);

			if(hShellTrayWnd != NULL)
			{
				hTrayNotify = FindWindowEx(hShellTrayWnd, NULL, "TrayNotifyWnd", NULL);

				if(hTrayNotify != NULL)
					hTool = FindWindowEx(hTrayNotify, NULL, "ToolbarWindow32", NULL);
			}

			if(hTool != NULL)
			{
				g_ShrData.hNotifyWnd = hNotifyWnd;
				g_ShrData.uCallbackMsg = uCallbackMsg;
				g_ShrData.bHookPause = FALSE;
				g_ShrData.hHook = SetWindowsHookEx(WH_GETMESSAGE, TrayMsgProc, g_hInst, GetWindowThreadProcessId(hTool, NULL));
				bRet = TRUE;
			}
		}
		else
		{
			g_ShrData.hNotifyWnd = hNotifyWnd;
			g_ShrData.uCallbackMsg = uCallbackMsg;
			g_ShrData.hHook = SetWindowsHookEx(WH_MOUSE_LL, TrayMouseLLProc, g_hInst, 0);
			bRet = TRUE;            			
		}
	}

	return bRet;
}

TRAYHK_API
BOOL WINAPI RemoveHook()
{
	BOOL	bRet = FALSE;

	if(g_ShrData.hHook != NULL)
	{
		UnhookWindowsHookEx(g_ShrData.hHook);
		g_ShrData.hHook = NULL;
		bRet = TRUE;
	}

	return bRet;
}

TRAYHK_API
BOOL WINAPI GetHookPause()
{
	return g_ShrData.bHookPause;
}

TRAYHK_API
VOID WINAPI SetHookPause(BOOL bPause)
{
	g_ShrData.bHookPause = bPause;
}